﻿require("core-js/stable");
require("classlist-polyfill");

const { hide, show, fadeIn, fadeOut } = require("../animation");
const { axios } = require("../network");

const first = document.getElementById("login-first-step");
const second = document.getElementById("login-second-step");
const container = document.getElementById("container");
const forgotPassword = document.getElementById("login-forgot-password");
const form = document.getElementById("login-form");
const nextBtn = document.getElementById("next-btn");
const backBtn = document.getElementById("back-btn");
const bookmarkNotice = document.getElementById("create-bookmark");
const forgotPasswordBtn = document.getElementById("forgot-password");
const firstStepInput = first.querySelector("#UserName,#Context");
const contextInput = document.getElementById("Context");
const usernameInput = document.getElementById("UserName");
const passwordInput = document.getElementById("Password");

let isFetching = false;
const title = document.title;

const baseURL = document.getElementById("ApplicationBaseUrl").value;

sessionStorage.setItem('notificationClosed', 'false');

function replaceUrl(newTitle, newUrl) {
    const stateData = window.history.data;
    document.title = newTitle;
    window.history.replaceState(stateData, newTitle, newUrl);
}

function resizeContainer(target) {
    container.style.height = `${target.clientHeight}px`;
}

function showFirstStep() {
    fadeOut(second);
    fadeIn(first);
    resizeContainer(first);
    if (firstStepInput === contextInput) {
        fadeOut(bookmarkNotice);
        replaceUrl(title, `${baseURL}Multimode`);
        usernameInput.focus();
    } else {
        contextInput.focus();
    }
}

function showBookmarkNotice() {
    if (window.localStorage.getItem("hide-bookmark-notice") === "true") return;
    fadeIn(bookmarkNotice, "-top", 4);
}

function showSecondStep() {
    fadeOut(first);
    fadeIn(second);
    if (firstStepInput === usernameInput) {
        passwordInput.focus();
    } else {
        usernameInput.focus();
        const context = contextInput.value;
        replaceUrl(context, `${baseURL}Multimode?c=${context}`);
        showBookmarkNotice();
    }
    resizeContainer(second);
}

resizeContainer(first);

function isClientSamlCallback({ data }) {
    if (data) {
        form.submit();
    } else {
        showSecondStep();
    }
    nextBtn.removeAttribute("disabled");
}

function toggleNextButton() {
    const firstStepValue = firstStepInput.value;
    if (!firstStepValue.length || isFetching) {
        nextBtn.disabled = true;
    } else {
        nextBtn.disabled = false;
    }
}

function onUsernameChanged() {
    const username = usernameInput.value;
    toggleNextButton();
    document.querySelectorAll(".username-value").forEach(el => {
        el.innerText = username;
    });
}

function onContextChanged() {
    if (!contextInput) return;
    const context = contextInput.value;
    toggleNextButton();
    document.querySelectorAll(".context-value").forEach(el => {
        el.innerText = context;
    });
}

function openForgotPassword(e) {
    e.preventDefault();
    fadeOut(second);
    fadeIn(forgotPassword);
    axios
        .get(e.target.href)
        .then(({ data }) => {
            forgotPassword.innerHTML = data;
            const cancelBtn = document.getElementById("cancel-btn");
            cancelBtn.addEventListener("click", function (e) {
                e.preventDefault();
                fadeOut(forgotPassword);
                fadeIn(second);
                passwordInput.focus();
                resizeContainer(second);
            });
            const emailInput = document.getElementById("Email");
            emailInput.focus();
            resizeContainer(forgotPassword);
        });
}

function verifyContext(e) {
    e.preventDefault();
    isFetching = true;
    toggleNextButton();
    const context = contextInput.value;
    axios
        .post("Multimode/IsContextSaml", {
            context
        })
        .then((result) => {
            isClientSamlCallback(result);
            isFetching = false;
            toggleNextButton();
        })
        .catch(() => {
            isFetching = false;
            toggleNextButton();
        });
}

function verifyUserName(e) {
    e.preventDefault();
    isFetching = true;
    toggleNextButton();
    const userName = usernameInput.value;
    axios
        .post("Account/IsClientSaml", {
            userName
        })
        .then((result) => {
            isClientSamlCallback(result);
            isFetching = false;
            toggleNextButton();
        })
        .catch(() => {
            isFetching = false;
            toggleNextButton();
        });
}

function onBack(e) {
    e.preventDefault();
    showFirstStep();
}

function onKey(e) {
    if (!first.contains(e.target)) {
        return;
    }
    if (e.keyCode === 13 || event.keyCode === 169) {
        e.preventDefault();
        if (firstStepInput === usernameInput) verifyUserName(e);
        else verifyContext(e);
        return false;
    }
}

backBtn.addEventListener("click", onBack);
forgotPasswordBtn.addEventListener("click", openForgotPassword);
window.addEventListener("keydown", onKey);

if (bookmarkNotice) {
    bookmarkNotice.querySelector(".button").addEventListener("click", () => {
        window.localStorage.setItem("hide-bookmark-notice", "true");
        fadeOut(bookmarkNotice);
    })
}

if (firstStepInput === usernameInput) {
    nextBtn.addEventListener("click", verifyUserName);
    usernameInput.addEventListener("input", onUsernameChanged);
    usernameInput.focus();
    onUsernameChanged();
} else {
    nextBtn.addEventListener("click", verifyContext);
    contextInput.addEventListener("input", onContextChanged);
    contextInput.focus();
    onContextChanged();
    if (contextInput.value.length) {
        hide(first);
        show(second);
        usernameInput.focus();
        resizeContainer(second);
        const context = contextInput.value;
        replaceUrl(context, `${baseURL}Multimode?c=${context}`);
    }
}